# category_entry_input.py

from Tkinter import *
#
import dialog
import resource

class CategoryEntryInput(dialog.Dialog):

    def __init__(self, master, categories, assoc):
        self.categories = categories    # all categories
        self.assoc = assoc  # categories associated with entry
 
        dialog.Dialog.__init__(self, master, "Edit categories for this entry")
     
    def body(self, master):
        frame = Frame(master)

        # listboxes get their own frame, or the scrollbars are messed up.
        f = Frame(frame)
        self.listbox_left = self.create_listbox(f)
        self.listbox_left.pack(side=LEFT, fill=BOTH)
        self.populate_listbox(self.listbox_left, self.assoc)
        f.pack(side=LEFT, fill=BOTH)

        midframe = Frame(frame)
        button_add = self.create_image_button(midframe, 
         "images/arrow_left.gif", self.add_category)
        button_add.pack(fill=Y, expand=1, padx=5, pady=5)
        button_remove = self.create_image_button(midframe, 
         "images/arrow_right.gif", self.remove_category)
        button_remove.pack(fill=Y, expand=1, padx=5, pady=5)
        midframe.pack(side=LEFT, fill=X)

        f = Frame(frame)
        self.listbox_right = self.create_listbox(f)
        self.listbox_right.pack(side=LEFT, fill=BOTH)
        self.populate_listbox(self.listbox_right, self.categories)
        f.pack(side=LEFT, fill=BOTH)
        
        frame.pack(fill=BOTH, expand=YES)
        return frame

    def create_listbox(self, master):
        scrollbar = Scrollbar(master, orient=VERTICAL)
        listbox = Listbox(master, yscrollcommand=scrollbar.set)
        listbox.configure(font=resource.SMALL_FONT, background="white",
         width=20, height=10)
        scrollbar.config(command=listbox.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
        return listbox

    def populate_listbox(self, listbox, lst):
        for item in lst:
            listbox.insert(END, item)
        
    def create_image_button(self, master, filename, command):
        """ Create a button with an image rather than text. """
        button = Button(master, command=command)
        button.image = PhotoImage(file=filename)
        button.config(image=button.image)
        return button
 
    def get_selection(self, listbox):
        """ Return the index of the currently selected entry. Return -1 if
            nothing is selected. """
        items = listbox.curselection()
        try:
            items = map(int, items)
        except ValueError:
            pass
        
        if items:
            return items[0]
        else:
            return -1

    def add_category(self, event=None):
        index = self.get_selection(self.listbox_right)
        if index > -1:
            item = self.categories[index]
            self.assoc.append(item)
            del self.categories[index]
            self.listbox_right.delete(ANCHOR)
            self.listbox_left.insert(END, item)

    def remove_category(self, event=None):
        index = self.get_selection(self.listbox_left)
        if index > -1:
            item = self.assoc[index]
            self.categories.append(item)
            del self.assoc[index]
            self.listbox_left.delete(ANCHOR)
            self.listbox_right.insert(END, item)

