# categorymanager.py

import re
import string

class CategoryManager:

    def __init__(self, db):
        self.db = db
        print self.db
        self.categories = []
        
    def load(self, filename):
        f = open(filename, "r")
        self.categories = [line.strip() for line in f.readlines() 
                           if line.strip()]
        f.close()
        
    def save(self, filename):
        self.categories.sort()
        f = open(filename, "w")
        for category in self.categories:
            print >> f, category
        f.close()
        
    def exists(self, category):
        l = string.lower(category)
        for cl in self.categories:
            if cl == l:
                return 1
        return 0
        
    def is_identifier(self, name):
        """ Return true if a string is a valid Python identifier. """
        m = re.match("[_A-Za-z][_A-Za-z0-9]*", name)
        return not not m
        
    def add(self, category):
        self.categories.append(category)
        
    def delete(self, category):
        """ Delete the given category and remove it from all entries. """
        print "Deleting:", category
        self.categories.remove(category)
        
        def delete_in_entry(entry, category=category):
            ec = entry.misc.get("categories", [])
            if category in ec:
                ec.remove(category)
                print "Deleting", category
                return 1
            return 0
            
        self.update_entries(delete_in_entry)
        
    def rename(self, oldname, newname):
        """ Rename the given category. Apply this to all entries. """
        idx = self.categories.index(oldname)
        if idx > -1:
            self.categories[idx] = newname
            
            def rename_in_entry(entry, oldname=oldname, newname=newname):
                ec = entry.misc.get("categories", [])
                try:
                    idx = ec.index(oldname)
                except ValueError:
                    return 0
                print "Renaming", oldname, "to", newname, "-- index", idx
                entry.misc["categories"][idx] = newname
                return 1
                
            self.update_entries(rename_in_entry)
        
    def update_entries(self, f):
        entries = self.db.get_entries_by_date("1900-01-01", "2999-12-31")
        mod_entries = []
        for entry in entries:
            print entry.blogentry_id, entry.misc
            modified = f(entry)
            if modified:
                mod_entries.append(entry)

        # todo: save...
        print "Updating entries:",
        for entry in mod_entries:
            self.db.update_entry(entry)
            print entry.blogentry_id,
        print "OK"
        