# configuration.py

class Configuration:
    """ Base class for configuration object. Every object can be loaded and
        saved from/to a file. """
        
    def __init__(self):
        self._filename = None

    def load(self, filename=None):
        if self._filename and not filename:
            filename = self._filename
        f = open(filename, "r")
        temp = {}
        for line in f.readlines():
            if line.strip():
                exec line in temp

        for key, value in temp.items():
            if not key.startswith("_"):
                setattr(self, key, value)

        self._filename = filename

    def save(self, filename=None):
        """ Save all attributes of the *instance*. (Not the method names, etc) 
        """
        if self._filename and not filename:
            filename = self._filename
        f = open(filename, "w")
        for key, value in self.get_attributes():
            print >> f, key, "=", repr(value)
        f.close()
        self._filename = filename

    def get_attributes(self):
        """ Get the names and values of the attributes of this object. """
        items = [(key, value) for (key, value) in self.__dict__.items()
                 if not key.startswith("_")]
        items.sort()
        return items        


class BlogInfo(Configuration):
    def __init__(self):
        Configuration.__init__(self)
        self.title = ""
        self.page_template_name = "page_template.html"
        self.entry_template_name = "entry_template.html"
        self.description = ""
        self.archive_method = "e:10"
        self.filename = "index.html"
        self.num_entries_fp = "20"
        self.default_author = "<anonymous>"
        self.only_post_updated = "0"  # default: post (i.e. create) everything
        self.only_publish_updated = "0"
        self.category_archives = "0"
        self.generate_rss = "1"
        self.root = ""

class FTPInfo(Configuration):
    def __init__(self):
        Configuration.__init__(self)
        self.host = "ftp.something.com"
        self.port = "21"
        self.login = "mylogin"
        self.password = "mypassword"
        self.start_dir = "mystartdir"

class Stats(Configuration):
    # This class cannot be edited by the user, but can be loaded and saved.
    def __init__(self):
        Configuration.__init__(self)
        self.publish_date = "2000-01-01 00:00:00"

