# dialog.py

from Tkinter import *
#
import resource

class Dialog(Toplevel):

    """ A standard dialog mechanism, based on the Dialog class in
        tkSimpleDialog.py.

        To use it, simply inherit from it, making sure you call Dialog's
        __init__ (last), and override body(), and possibly validate() and
        apply().
    """

    def __init__(self, parent, title=None):
        Toplevel.__init__(self, parent)
        self.transient(parent)

        if title:
            self.title(title)
        self.parent = parent
        self.result = None

        body = Frame(self)
        self.initial_focus = self.body(body)
        body.pack(padx=5, pady=5, expand=Y, fill=BOTH)

        self.create_buttons()
        self.grab_set()
        if not self.initial_focus:
            self.initial_focus = self

        self.protocol("WM_DELETE_WINDOW", self.cancel_pressed)
        if self.parent is not None:
            self.geometry("+%d+%d" % (parent.winfo_rootx() + 50,
             parent.winfo_rooty() + 50))
        self.initial_focus.focus_set()
        self.wait_window(self)

    def destroy(self):
        self.initial_focus = None
        Toplevel.destroy(self)

    def body(self, master):
        pass

    def create_buttons(self):
        box = Frame(self, relief=GROOVE, borderwidth=1)
        
        ok_button = Button(box, text="OK", font=resource.SMALL_FONT,
         command=self.ok_pressed, default=ACTIVE)
        ok_button.pack(side=LEFT, padx=5, pady=5)

        cancel_button = Button(box, text="Cancel", font=resource.SMALL_FONT,
         command=self.cancel_pressed)
        cancel_button.pack(side=LEFT, padx=5, pady=5)

        self.bind("<Return>", self.ok_pressed)
        self.bind("<Escape>", self.cancel_pressed)
        
        box.pack(side=LEFT, fill=X, expand=1)

    ###
    ### standard button semantics

    def ok_pressed(self, event=None):
        if not self.validate():
            self.initial_focus.focus_set()
            return
        self.withdraw()
        self.update_idletasks()
        self.apply()
        self.cancel_pressed()
        self.result = "ok"

    def cancel_pressed(self, event=None):
        if self.parent is not None:
            self.parent.focus_set()
        self.destroy()
        self.result = "cancel"

    ###
    ### command hooks

    def validate(self):
        return 1    # override

    def apply(self):
        pass    # override

