# ftpinfo_input.py

from Tkinter import *
import string
#
import input_dialog
import resource


class FTPInfoInput(input_dialog.InputDialog):

    prefix = "ftp_"

    def body(self, master):
        frame = Frame(master)

        f1 = self.create_inputbox(frame, "FTP server ::", "host", 40)
        f1.pack(side=TOP, fill=X, pady=1)

        f2 = self.create_inputbox(frame, "Port ::", "port", 10)
        f2.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f1.inputbox, f2.inputbox)

        f3 = self.create_inputbox(frame, "Login ::", "login", 15)
        f3.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f2.inputbox, f3.inputbox)

        f4 = self.create_inputbox(frame, "Password ::", "password", 15)
        f4.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f3.inputbox, f4.inputbox)

        f5 = self.create_inputbox(frame, "Start directory ::", "start_dir", 40)
        f5.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f4.inputbox, f5.inputbox)
        input_dialog.set_tablink(f5.inputbox, f1.inputbox)

        frame.pack(fill=BOTH, expand=YES)
        
        self.load()
        f1.focus_set()
        return frame


