# htmlmaker.py

import sys
import os
import string
#
import renderer

class HTMLMaker:

    def __init__(self, blog, page_template_file=None, entry_template_file=None, 
     macros=(), globalmod=None):
        self.blog = blog
        self.globalmod = globalmod

        # XXX this messing around with default arguments is hairy. A better
        # solution is desirable.
        if page_template_file:
            self.page_template = open(page_template_file, "rb").read()
        else:
            self.page_template = ""
        if entry_template_file:
            self.entry_template = open(entry_template_file, "rb").read()
        else:
            self.entry_template = ""

        self.entry_blocks = []
        # if archives are made, the "entry blocks" are put here, so other code
        # can reuse it if necessary

        self.macros = macros

    def make_page(self, entries):
        """ Generate a page, using the templates and the renderer. """
        namespace = {}
        if self.globalmod:
            namespace.update(self.globalmod.__dict__)
        namespace["blog"] = self.blog

        for entry in entries:
            entry.text = renderer.render(entry.text, namespace)

        self.blog.entries = entries  # picked by by Blog.messages()
        self._set_anchors(entries, self.blog)
        self.blog.entry_template = self.entry_template
        html = renderer.render(self.page_template, namespace)
        if self.macros:
            html = self.expand_macros(html)
        return html

    def make_archives(self, database, visible_only=0):
        """ Make all archive pages, using the archiving method in self.blog. 
            Also writes the files to the appropriate directory. """
        pages = []
            
        for i in range(len(self.blog.entry_blocks)):
            arch_id, ids = self.blog.entry_blocks[i]
            # get the real, "full" entries
            entries = database.get_entries_by_idlist(ids)
            
            # set current, previous, next page
            self.blog.current_page = self.blog.archives[i][0]
            if i > 0:
                self.blog.previous_page = self.blog.archives[i-1][0]
            else:
                self.blog.previous_page = ""
            if i < len(self.blog.entry_blocks)-1:
                self.blog.next_page = self.blog.archives[i+1][0]
            else:
                self.blog.next_page = ""

            # set entry count (first entry = 1)
            for i in range(len(entries)):
                entries[i].count = i + 1
            # set page count (first page = 1)
            self.blog.count = i + 1

            # make the page
            print "Generating page:", self.blog.current_page
            html = self.make_page(entries)
            pages.append((self.blog.current_page, html))

        # if blog is used afterwards, these need not be set
        self.blog.next_page = self.blog.previous_page = ""
        self.entry_blocks = self.blog.entry_blocks   # XXX what's this?

        return pages

    def expand_macros(self, html):
        for occ, tag, attribute, value in self.macros:
            idx = string.find(html, occ)
            # so far, only replaces the first occurrence
            if idx > -1:
                newstr = '<%s %s="%s">%s</%s>' % (
                 tag, attribute, value, occ, tag)
                html = string.replace(html, occ, newstr, 1)
                print "Woot!", occ, "->", newstr
        return html

    def make_category_pages(self, categories, database, number):
        """ Write a page for every category. """
        pages = []
        print "Generating categories:",
        for category in categories:
            entries = database.get_entries_by_category(number, category)
            pagename = "arch_%s.html" % (category,)
            self.blog.current_page = pagename
            html = self.make_page(entries)
            #self.write_page(pagename, html, database,
            # update_only=int(self.blog.only_post_updated))
            pages.append((pagename, html))
            sys.stdout.write(".")
        print " OK"

        return pages

    def _set_anchors(self, entries, blog):
        """ Set the anchor attribute of a list of entries. """
        for entry in entries:
            permalink = blog.get_permalink(entry.blogentry_id)
            entry.anchor = permalink

