# htmlwriter.py

import os

class HTMLWriter:

    def write_page(self, filename, html, database, update_only=0):
        dir = "html_" + database.name
        if not os.path.exists(dir):
            os.mkdir(dir)
        fullname = os.path.join(dir, filename)

        if update_only:
            # let's see if the new file differs from the old one...
            data = self.get_existing_page(fullname)
            if data == html:
                print "File", fullname, "skipped (exact same version exists)"
                return  # don't write the page again

        f = open(fullname, "wb")
        f.write(html)
        f.close()
 
    def get_existing_page(self, filename):
        try:
            f = open(filename, "rb")
        except IOError:
            return ""
        data = f.read()
        f.close()
        return data

        
