# publisher.py

import ftplib
import os
import time
# 
import date

class Publisher:
    """ Publish, i.e. upload, files in a given directory. """

    def __init__(self, database, ftpinfo, stats):
        self.db = database
        self.ftpinfo = ftpinfo
        self.stats = stats

        self.ftp = None # will be an FTP instance once connected

    def publish_dir(self, dirname, new_only=0):
        """ Publish all files in a directory. """
        now = date.Date().isodate()
        filenames = os.listdir(dirname)
        fullnames = [os.path.join(dirname, filename) for filename in filenames]
        try:
            self.connect()
            for fullname in fullnames:
                if new_only:
                    file_date = self.get_file_date(fullname)
                    if file_date <= self.stats.publish_date:
                        print "Skipping upload for", fullname
                        continue    # don't upload this, it hasn't changed
                self.upload(fullname)
            self.disconnect()
        except:
            raise
        else:
            # set current date/time as the new publish date, but only if there
            # were no errors
            self.stats.publish_date = now
            self.stats.save() 

    def upload(self, filename):
        # only works if we're connected
        if self.ftp:
            name = os.path.split(filename)[1]
            print "Storing", name, "...",
            f = open(filename, "rb")
            self.ftp.storbinary("STOR " + name, f)
            f.close()
            print "OK"

    def connect(self):
        print "Connecting to", self.ftpinfo.host, "..."
        ftp = ftplib.FTP()
        ftp.connect(self.ftpinfo.host, self.ftpinfo.port)
        print ftp.getwelcome()
        ftp.login(self.ftpinfo.login, self.ftpinfo.password)
        if self.ftpinfo.start_dir:
            try:
                ftp.cwd(self.ftpinfo.start_dir)
            except ftplib.error_perm, e:
                if e.args and e.args[0].startswith("550"):
                    print "Start directory not found. Creating...",
                    ftp.mkd(self.ftpinfo.start_dir)
                    print "OK"
                    ftp.cwd(self.ftpinfo.start_dir)
                else:
                    raise
        self.ftp = ftp

    def disconnect(self):
        if self.ftp:
            print "All tasks done. Disconnecting...",
            self.ftp.quit()
            print "OK"

    def get_file_date(self, filename):
        stats = os.stat(filename)
        atime, mtime, ctime = stats[-3:]
        #return "%04d-%02d-%02d %02d-%02d-%02d" % tuple(mtime[:6])
        return date.Date(time.localtime(mtime)).isodate()


