# rsswriter.py
# Generate RSS 0.91 files.

import string
import urlparse
#
import htmltools

template1 = """\
<?xml version="1.0"?>
<!DOCTYPE rss PUBLIC "-//Netscape Communications//DTD RSS 0.91//EN"
"http://my.netscape.com/publish/formats/rss-0.91.dtd">
<rss version="0.91">
  <channel>
    <title>%(title)s</title>
    <link>%(link)s</link>
    <description>%(description)s</description>
    %(items)s
  </channel>
</rss>
"""

template2 = """\
    <item>
      <title>%(title)s</title>
      <link>%(link)s</link>
      <description>%(description)s</description>
    </item>
"""

class RSSWriter:

    def __init__(self, blog, entries):
        self.blog = blog
        self.entries = entries
        
    def generate_rss(self, verbose=0):
        """ Create RSS as one long string. """
        title = htmltools.strip_html(self.blog.title)
        link = urlparse.urljoin(self.blog.root, "index.html")
        description = htmltools.strip_html(self.blog.description)
        items = [self.generate_rss_item(entry, verbose=verbose) 
                 for entry in self.entries]
        items = string.join(items, "")
        return template1 % locals()
        
    def generate_rss_item(self, entry, verbose=0):
        """ Generate an RSS <item> tag with entry data. The <description> will
            be filled with a *summary* of the entry text. 
        """
        title = htmltools.strip_html(entry.title)
        link = urlparse.urljoin(self.blog.root, 
               self.blog.get_permalink(entry.blogentry_id))
        if verbose:
            description = "<![CDATA[" + entry.text + "]]>"
            # this seems to be invalid for RSS 0.91.
        else:
            description = htmltools.first_sentence(entry.text)
        return template2 % locals()

