# statusbar.py

from Tkinter import *
#
import resource

class StatusBar(Frame):

    def __init__(self, master, widths=(100,)):
        Frame.__init__(self, master, relief=GROOVE, borderwidth=1)
        self.labels = []
        for i in range(len(widths)):
            if i == len(widths) - 1:
                width = 0
            else:
                width = widths[i]
            label = self.add_panel(width)
            self.labels.append(label)

    def add_panel(self, width=0):
        """ Add a panel. The last panel should have width=0, and will occupy
            all the space left on the spacebar. """
        f = Frame(self, borderwidth=1, relief=GROOVE)
        label = Label(f, text="", font=resource.SMALL_FONT, justify=LEFT, 
         anchor=W)
        if width:
            label.config(width=width)
        label.pack(side=LEFT, fill=X, expand=YES)
        f.pack(side=LEFT, fill=X, expand=(width == 0) and YES or NO)
        return label

    def set_text(self, panelno, text):
        label = self.labels[panelno]
        label.config(text=text)

