# main.py

from wxPython.wx import *
import sys
import getopt
import os
#
import mainframe
import options
import tools

__version__ = "0.3 15/21"

class MyApp(wxApp):

    def __init__(self, root, *args, **kwargs):
        self.where_am_i = root
        wxApp.__init__(self, *args, **kwargs)

    def OnInit(self):
        self.options = self.load_options()
        title = ":: Charm %s ::" % (__version__,)
        self.frame = mainframe.MainFrame(NULL, self.options, title)
        self.frame.Show(true)
        self.frame.where_am_i = self.where_am_i
        self.SetTopWindow(self.frame)
        return true

    def load_options(self):
        o = options.Options()
        path = os.path.join(self.where_am_i, "options.txt")
        o.load(path)
        return o


if __name__ == "__main__":

    where_am_i = os.path.split(os.path.abspath(sys.argv[0]))[0]
    print "I am at:", where_am_i
    opts, args = getopt.getopt(sys.argv[1:], "")

    app = MyApp(where_am_i, 0)
    app.frame.where_am_i = where_am_i
    if args:
        app.frame.bulkload(args)
    app.MainLoop()

