# cmdline.py

from wxPython.wx import *
import os
import string

# IDEA:
# Maybe this should be a dropdownbox, where the drop-down list could
# function as a history of commands entered... at the same time, you can
# enter new command in the edit area.

class CmdLine(wxTextCtrl):

    def __init__(self, parent, mainframe, options):
        self.id = wxNewId()
        wxTextCtrl.__init__(self, parent, self.id, "",
         style=wxTE_PROCESS_ENTER)
        self.mainframe = mainframe  # necessary to call top-level methods
        self.options = options
        
        self.SetFont(self.options.wx_system_font)
        
        EVT_KEY_DOWN(self, self.EvtChar)
        
    def EvtChar(self, event=None):
        keycode = event.GetKeyCode()
        if keycode == 13:
            self.execute(self.GetValue())
        elif keycode == 27:
            self.mainframe.set_focus_editor()
            # move focus to the current tab (usually an editor)
        else:
            event.Skip()
            
    def execute(self, s):
        s = string.strip(s)
        print "Execute:", `s`
        # deal with special commands first...
        if s.startswith(":"):
            self.sc_colon(s[1:])
        # - starting with /
        elif s.startswith("/"):
            print "Yet to be implemented!"
        elif s.startswith("!"):
            print "Yet to be implemented!"
            # !% should mean, run the current file
            # !foo means, run 'foo' in the shell
            command = s[1:]
            if command.startswith("%"):
                ed = self.get_editor()
                if ed:
                    filename = ed.get_filename()
                    command = filename + command[1:]
            print "Command line:", command
            os.system("start " + command)   # Windows only, for now
        else:
            parts = string.split(s) # FIXME
            # this should be a better split, that allows for quotes
            if hasattr(self, "cmd_" + parts[0]):
                f = getattr(self, "cmd_" + parts[0])
                f(*parts[1:])
            else:
                print "Invalid command:", parts[0]
                
        # Q: Do we move the focus after a successful command? Or maybe just
        # after certain ones? (like ':')
        
    ###
    ### quick shortcuts
    
    def sc_colon(self, cmd):
        lineno = int(cmd)
        ed = self.get_editor()
        if ed:
            print "Moving to line", lineno-1
            ed.GotoLine(lineno-1)
        
    ###
    ### commands
    
    def cmd_echo(self, *args):
        print args
        
    def cmd_trans(self, funcname):
        import transformations
        if hasattr(transformations, funcname):
            f = getattr(transformations, funcname)
            ed = self.get_editor()
            if ed:
                # get selected text, or all text if nothing is selected
                text = ed.GetSelectedText()
                # pass it through the transformation function
                newtext = f(text)
                # put it back
                ed.ReplaceSelection(newtext)
        else:
            print "Function", funcname, "not found."
        
    # XXX
    # Not sure yet how this command line will work, and what it will do...
    
    def get_editor(self):
        """ Get the current editor, if any. """
        mainframe = self.GetGrandParent()
        ed = mainframe.notebook.get_current_page()
        return ed   # could be None
    
    
'''
I find the following shortcuts handy:

:<linenum>  e.g. :206
jump to the given line number.

/regex      e.g. /foo
find text matching the regular expression.

Other than that, it's probably best to use commands of the form
 'command param1 param2 ...'
'''