# fileselector.py

from wxPython.wx import *


class FileSelector(wxPanel):

    def __init__(self, parent, options):
        self.id = wxNewId()
        wxPanel.__init__(self, parent, self.id, size=(90, 50))
        self.options = options
        self.notebook = None    # set this later

        # add dropdownbox...
        id = wxNewId()
        self.combobox = wxComboBox(self, id, "", wxPoint(0,0),
         wxSize(95, -1), [], wxCB_READONLY)
        self.combobox.id = id
        self.combobox.SetFont(self.options.wx_system_font)

        # this sizer makes the combobox fill up the whole panel, but leaves a
        # tiny border:
        box = wxBoxSizer(wxVERTICAL)
        box.Add(self.combobox, 1, wxEXPAND|wxALL, 1)
        
        EVT_COMBOBOX(self.combobox, self.combobox.id, self.EvtSelect)
        
        self.sizer = box
        self.sizer.Fit(self)
        self.SetAutoLayout(true)
        self.SetSizer(self.sizer)
        
    def EvtSelect(self, event=None):
        #print "You selected:", self.combobox.GetSelection()
        if self.notebook:
            idx = self.combobox.GetSelection()
            self.notebook.SetSelection(idx)

    def update(self):
        """ Update list from the notebook. This should be called whenever a tab
            is added or removed from the notebook. 
        """
        if self.notebook:
            self.combobox.Clear()
            for i in range(self.notebook.GetPageCount()):
                win = self.notebook.GetPage(i)
                s = "[%d] %s" % (i+1, win.get_filename())
                self.combobox.Append(s, s)
            
