# lexers.py

from wxPython.wx import *
from wxPython.stc import *
import keyword

# associate lexer strings with wxPython (stc.h) constants
lexers = {
    "Python": wxSTC_LEX_PYTHON,
    "C++": wxSTC_LEX_CPP,
    "XML": wxSTC_LEX_XML,
}
# more lexers follow... see stc.h

# lexical elements
lex_elements = {
    "Python": {
        "default": wxSTC_P_DEFAULT,
        "comment": wxSTC_P_COMMENTLINE,
        "number": wxSTC_P_NUMBER,
        "string": wxSTC_P_STRING,
        "character": wxSTC_P_CHARACTER,
        "word": wxSTC_P_WORD,
        "triple": wxSTC_P_TRIPLE,
        "triple_double": wxSTC_P_TRIPLEDOUBLE,
        "classname": wxSTC_P_CLASSNAME,
        "defname": wxSTC_P_DEFNAME,
        "operator": wxSTC_P_OPERATOR,
        "identifier": wxSTC_P_IDENTIFIER,
        "commentblock": wxSTC_P_COMMENTBLOCK,
        "stringeol": wxSTC_P_STRINGEOL,
    },
}

lex_keywords = {
    "Python": keyword.kwlist,
}
