# mainframe.py

from wxPython.wx import *
import os
import sys
#
import cmdline
import date
import editor
import fileselector
import help
import menumaker
import notebook
import tools

class MainFrame(wxFrame):
    
    def __init__(self, parent, options, title):
        self.id = wxNewId()
        wxFrame.__init__(self, parent, self.id, title, size=(400,400),
         style=wxDEFAULT_FRAME_STYLE)
        self.options = options
        self.where_am_i = ""
    
        # add components here...
        self.statusbar = self.CreateStatusBar()
        self.statusbar.SetFieldsCount(3)
        self.statusbar.SetStatusWidths([200, 350, -1])
        # XXX how do make the second panel wider?
        
        # menu; this should move to a separate method later, and be created
        # automagically from a nested list or so
        menubar = self.create_menu()
        self.SetMenuBar(menubar)

        box = wxBoxSizer(wxVERTICAL)
        box.Add(wxButton(self, 1010, "one"), 0, wxEXPAND)

        # fileselector and command line are created here
        twobar = self.create_twobar()
        box.Add(twobar, 0, wxEXPAND|wxALL)

        self.notebook = notebook.Notebook(self, self.options)
        self.notebook.coords_callback = self.display_coordinates
        box.Add(self.notebook, 1, wxEXPAND)
        
        # associate fileselector with notebook
        self.fileselector.notebook = self.notebook

        self.sizer = box
        self.sizer.Fit(self)
        self.SetAutoLayout(true)
        self.SetSizer(self.sizer)

        self.create_keybindings()
        
        # setting an icon...
        #iconpath = os.path.join(self.where_am_i, "Swan_amber.ico")
        iconpath = tools.find_file("Swan_amber.ico")
        print iconpath
        # XXX it may be look better to look everywhere on sys.path >=(
        icon = wxIcon(iconpath, wxBITMAP_TYPE_ICO)
        self.SetIcon(icon)
        
        EVT_COMMAND_FIND(self, -1, self.OnFind)
        EVT_COMMAND_FIND_NEXT(self, -1, self.OnFindNext)
        # etc, see demo
        EVT_COMMAND_FIND_CLOSE(self, -1, self.OnFindClose)
             
        self.Show(true)

    def create_menu(self):
        # eventually, this will be configurable
        # also, we need to split the text and the hotkeys...
        items = [
            ["&File", 
                ["&New", "Ctrl-N", "New file", self.file_new],
                ["&Open...", "Ctrl-O", "Open file in new page", self.file_open],
                ["&Save...", "Ctrl-S", "Save file", self.file_save],
                ["&Save as...", "Shift-Ctrl-S", "Save file under a new name",
                 self.file_save_as],
                ["&Close", "Ctrl-X", "Close file", self.file_close],
                "-",
                ["&Next page", "F6", "Move to the next page", self.next_page],
                ["&Previous page", "F5", "Move to the previous page",
                 self.previous_page],
                "-",
                ["&About", "", "Information about this program", 
                 self.file_about],
                ["E&xit", "Alt-X", "Terminate the program", self.file_exit],
            ],
            ["&Edit",
                ["Undo", "Ctrl-Z", "Undo", self.edit_undo],
                ["Redo", "", "Redo", self.edit_redo],
                "-",
                ["Cut", "Shift-Del", "", self.edit_cut],
                ["Copy", "Ctrl-Ins", "", self.edit_copy],
                ["Paste", "Shift-Ins", "", self.edit_paste],
                ["Clear", "", "", self.edit_clear],
                "-",
                ["Find", "Ctrl-F", "", self.edit_find],
                ["Find next", "Ctrl-G", "", self.edit_find_next],
                "-",
                ["Delete line", "Ctrl-Y", "Delete current line", 
                 self.edit_delete_line],
            ],
            ["&View",
                ["*Show whitespace", "", "Make whitespace visible", 
                 self.view_show_whitespace],
                ["*Indentation guides", "", "Show or hide indentation guides", 
                 self.view_show_indentguides],
                ["*Folding", "", "", self.view_folding],
            ],
            ["&Python", 
                ["&Shell", "", "Open interactive interpreter",
                 self.python_shell],
                ["*Shell with filling?", "", "", self.python_shell_with_filling],
                ["Import module in shell", "", "", 
                 self.python_import_module_in_shell],
                "-",
                ["Execute", "F9", "Execute file", self.execute],
            ],
            ["&Debug",
                ["Bootstrap", "", "", self.debug_bootstrap],
            ],
            ["&Help",
                ["Help on &Python", "F1", 
                 "Look up a Python keyword, module, function or method",
                 self.help_python],
                ["View module", "Shift-F1", "View a Python module", 
                 self.help_view_module],
            ],
        ]
        return menumaker.menumaker(self, items)

    def create_keybindings(self):
        EVT_KEY_UP(self, self.OnKeyUp)
        # later, create a faster mapping list 

    def create_twobar(self):
        w = wxSplitterWindow(self, wxNewId())
        p1 = fileselector.FileSelector(w, self.options)
        self.fileselector = p1
        p2 = cmdline.CmdLine(w, self, self.options)
        self.cmdline = p2
        w.SetMinimumPaneSize(20)
        w.SplitVertically(p1, p2)
        w.SetSashPosition(100)
        w.SetSize((680, 24))
        return w

    def OnKeyUp(self, event=None):
        print event.GetKeyCode()
        # XXX is this obsolete?

    ###
    ### File menu

    def file_about(self, event=None):
        print "Hello, world!"

    def file_exit(self, event=None):
        self.Close(true)
        self.fileselector.update()

    def file_open(self, event=None):
        masks = self.options.filemask
        dlg = wxFileDialog(self, "Open file", "", "", masks,
         wxOPEN|wxMULTIPLE)
        if dlg.ShowModal() == wxID_OK:
            for path in dlg.GetPaths():
                self.notebook.open_file(path)
        self.fileselector.update()

    def bulkload(self, filenames):
        for filename in filenames:
            try:
                self.notebook.open_file(filename)
            except:
                print "Could not open", filename

    def file_save(self, event=None):
        # to do this, we must know the current file first
        # (current page, etc)
        ed = self.notebook.get_current_page()
        if ed.filename:
            ed.save(ed.filename)
            self.sb_message("%s saved at %s" % (ed.filename,
             date.Date().isodate()))
        else:
            # ask for filename, then save
            masks = self.options.filemask
            dlg = wxFileDialog(self, "Save file", "", "", masks, wxSAVE)
            if dlg.ShowModal() == wxID_OK:
                for path in dlg.GetPaths():
                    ed.save_as(path)
                    self.sb_message("%s saved at %s" % (path,
                     date.Date().isodate()))
                    self.notebook.rename_tab(path)
        self.fileselector.update()

    def file_save_as(self, event=None):
        """ Save file under a new name. The current file takes that name. """
        ed = self.notebook.get_current_page()
        masks = self.options.filemask
        dlg = wxFileDialog(self, "Save file as", "", "", masks, wxSAVE)
        if dlg.ShowModal() == wxID_OK:
            for path in dlg.GetPaths():
                ed.save_as(path)
                self.sb_message("%s saved at %s" % (path,
                 date.Date().isodate()))
                self.notebook.rename_tab(path)
        self.fileselector.update()
        # XXX parts of this could be passed down to the notebook, but not the
        # dialog...
        # XXX and, there's too much duplicate code here >=(

    def file_new(self, event=None):
        self.notebook.new()
        self.fileselector.update()

    def file_close(self, event=None):
        idx = self.notebook.GetSelection()
        if idx >- 1:
            self.notebook.DeletePage(idx)
            self.fileselector.update()
        # XXX may be moved to a notebook method. and it will be polite to ask 
        # the if they want to save any changes first... 

    def next_page(self, event=None):
        self.notebook.next_page()

    def previous_page(self, event=None):
        self.notebook.previous_page()

    ###
    ### python stuff

    def python_shell(self, event=None):
        self.notebook.python_shell()
        self.fileselector.update()

    def python_shell_with_filling(self, event=None):
        self.options.shell_with_filling = event.Checked()
        
    def python_import_module_in_shell(self, event=None):
        # get the current module name
        win = self.notebook.get_current_page()
        if win:
            if isinstance(win, editor.Editor):
                filename = win.get_filename()
                print "filename:", filename
                path, file = os.path.split(filename)
                name, ext = os.path.splitext(file)
                if ext != ".py":
                    print >> sys.stderr, "Not a Python file:", filename
                else:
                    print "We must import:", name
                    self.notebook.python_shell_import(name)
                    self.fileselector.update()
            else:
                print >> sys.stderr, "No file selected."
        
    def execute(self, event=None):
        win = self.notebook.get_current_page()
        if isinstance(win, editor.Editor):
            os.startfile(win.filename)
        else:
            print >> sys.stderr, "Ja, poepe! Dat kan niet!"

    ###
    ### statusbar

    def sb_message(self, message):
        """ Put some text in the _middle_ panel of the statusbar. """
        self.statusbar.SetStatusText(message, 1)

    def display_coordinates(self, x, y):
        win = self.notebook.get_current_page()
        if isinstance(win, editor.Editor) \
        and win.GetReadOnly():
            readonly = "[R]"
        else:
            readonly = ""
        s = "x: %s y: %s %s" % (x, y, readonly)
        self.statusbar.SetStatusText(s, 2)

    ###
    ### clipboard and other editing stuff

    def edit_cut(self, event):
        try:
            win = self.notebook.get_current_page()
        except ValueError:
            pass
        else:
            # XXX this kind of coding is ugly; fix it soon
            if hasattr(win, "Cut"):
                win.Cut()
                
    def edit_copy(self, event):
        try:
            win = self.notebook.get_current_page()
        except ValueError:
            pass
        else:
            if hasattr(win, "Copy"):
                win.Copy()
 
    def edit_paste(self, event):
        try:
            win = self.notebook.get_current_page()
        except ValueError:
            pass
        else:
            if hasattr(win, "Paste"):
                win.Paste()

    def edit_clear(self, event):
        try:
            win = self.notebook.get_current_page()
        except ValueError:
            pass
        else:
            if hasattr(win, "Clear"):
                win.Clear()
                # XXX somehow, this doesn't work yet

    def edit_delete_line(self, event):
        try:
            win = self.notebook.get_current_page()
        except ValueError:
            pass
        else:
            if hasattr(win, "delete_current_line"):
                win.delete_current_line()
                
    def edit_find(self, event=None):
        win = self.notebook.get_current_page()
        if win and hasattr(win, "FindText"):
            data = wxFindReplaceData()
            dlg = wxFindReplaceDialog(self, data, "Find")
            dlg.data = data
            dlg.Show(true)
        else:
            print "No editor is currently active."
        
    def edit_find_next(self, event=None):
        """ to be implemented """
        
    def OnFind(self, event=None):
        print event.GetFindString(), event.GetFlags()
        findtext = event.GetFindString()
        win = self.notebook.get_current_page()
        if win and hasattr(win, "FindText"):
            pos = win.FindText(0, win.GetLength(), findtext, 0)
            # flags can be set later
            print "Position:", pos
            if pos > -1:
                win.GotoPos(pos)
                win.SetSelectionStart(pos)
                win.SetSelectionEnd(pos+len(findtext))
                win.find_results = (findtext, pos)
            else:
                print "** not found **"
                
    def OnFindNext(self, event=None):
        print 'onfindnext'
        findtext = event.GetFindString()
        win = self.notebook.get_current_page()
        if win and hasattr(win, "FindText"):
            print "old results:", win.find_results
            pfindtext, ppos = win.find_results
            if pfindtext != findtext:
                print "ppos is reset", `pfindtext`, `findtext`
                ppos = -1    # start from beginning again
            pos = win.FindText(ppos+1, win.GetLength(), findtext, 0)
            # flags can be set later
            print "Position:", pos
            if pos > -1:
                win.GotoPos(pos)
                win.SetSelectionStart(pos)
                win.SetSelectionEnd(pos+len(findtext))
                win.find_results = (findtext, pos)
            else:
                print "** not found **"
        
    def OnFindClose(self, event=None):
        """ When the Find dialog is closed, destroy it so it doesn't linger
            in memory. """
        event.GetDialog().Destroy()
        
    def edit_undo(self, event=None):
        win = self.notebook.get_current_page()
        if win and hasattr(win, "Undo"):
            win.Undo()
        
    def edit_redo(self, event=None):
        win = self.notebook.get_current_page()
        if win and hasattr(win, "Redo"):
            win.Redo()
                
    ###
    ### view menu
    
    def view_show_whitespace(self, event=None):
        self.options.show_whitespace = event.Checked()
        # apply this to all editor windows!
        for i in range(self.notebook.GetPageCount()):
            win = self.notebook.GetPage(i)
            if hasattr(win, "SetViewWhiteSpace"):
                win.SetViewWhiteSpace(self.options.show_whitespace)
                
    def view_show_indentguides(self, event=None):
        self.options.show_indentguides = event.Checked()
        for ed in self.notebook.get_editors():
            ed.SetIndentationGuides(self.options.show_indentguides)
            
    def view_folding(self, event=None):
        self.options.folding = event.Checked()
        for ed in self.notebook.get_editors():
            ed.set_folding(self.options.folding)
    
    ###
    ### debug menu
    
    def debug_bootstrap(self, event=None):
        """ Open another editor with the same files open. """

    ###
    ### help
    
    def help_python(self, event):
        dlg = wxTextEntryDialog(self, "Enter search term:", "Pythonic help", "")
        if dlg.ShowModal() == wxID_OK:
            value = dlg.GetValue()
            value = value.encode("utf-8")   # get rid of Unicode
        dlg.Destroy()
        
        self._help_python(value)
        
    def _help_python(self, searchterm):
        # capture output of help(), that normally goes to stdout
        import cStringIO
        oldstdout = sys.stdout
        try:
            sys.stdout = cStringIO.StringIO()
            help.help(searchterm)
            text = sys.stdout.getvalue()
        finally:
            sys.stdout = oldstdout
            
        self.notebook.add_help(searchterm, text)
        self.fileselector.update()
        
    def help_view_module(self, event=None):
        dlg = wxTextEntryDialog(self, "Enter module name:", "View module", "")
        if dlg.ShowModal() == wxID_OK:
            value = dlg.GetValue()
            value = value.encode("utf-8")
        dlg.Destroy()
        
        self._help_view_module(value)
        self.fileselector.update()
        
    def _help_view_module(self, modulename):
        if not modulename.endswith(".py"):
            filename = modulename + ".py"
        else:
            filename = modulename
        fullname = tools.find_file(filename)    # find module on sys.path
        if fullname:
            self.notebook.open_file(fullname, readonly=1)
        else:
            print >> sys.stderr, modulename, "not found"
        
    ###
    ### focus
    
    def set_focus_editor(self):
        """ Set the focus to the current editor/tab. """
        win = self.notebook.get_current_page()
        if win:
            win.SetFocus()
        
    def set_focus_command_line(self, event=None):
        self.cmdline.SetFocus()
        