# menumaker.py

from wxPython.wx import *

def menumaker(win, lst):
    """ Create a menu, based on a list of data. 
        An example list:

        items = [
            ["&File", 
                ["&About", "Alt-H", "Information about this program", 
                 self.file_about],
                "-",    # separator
                ["E&xit", "Alt-X", "Terminate the program", self.file_exit],
            ],
            ["&Other", ],
        ]
        
        If a name starts with a '*', then the menu item is considered to be
        a 'check' item (like a checkbutton).
        If a name starts with a '#', then the menu item is considered to be
        a 'radio' item (like a radiobutton).
    """
    menubar = wxMenuBar()
    for m in lst:
        menuname, items = m[0], m[1:]
        menu = wxMenu()
        for item in items:
            if item == "-":
                menu.AppendSeparator()
            else:
                otype = wxITEM_NORMAL
                name, hotkey, description, function = item
                if name.startswith("*"):
                    name = name[1:]
                    otype = wxITEM_CHECK
                elif name.startswith("#"):
                    name = name[1:]
                    otype = wxITEM_RADIO
                id = wxNewId()
                if hotkey:
                    name = name + "\t" + hotkey
                menu.Append(id, name, description, otype)
                menu.id = id
                EVT_MENU(win, id, function)

        menubar.Append(menu, menuname)

    return menubar
