# notebook.py

from wxPython.wx import *
from wxPython.stc import *
from wxPython.lib.PyCrust import shell, version, filling
import os
#
import editor
import shell

class NotebookFileDrop(wxFileDropTarget):
    def __init__(self, window):
        wxFileDropTarget.__init__(self)
        self.window = window
    def OnDropFiles(self, x, y, filenames):
        print filenames, "dropped"
        for filename in filenames:
            self.window.open_file(filename)

class Notebook(wxNotebook):

    def __init__(self, parent, options):
        self.id = wxNewId()
        wxNotebook.__init__(self, parent, self.id, size=(720,420))
        self.options = options
        
        self.filedrop = NotebookFileDrop(self)
        self.SetDropTarget(self.filedrop)

        self.SetFont(self.options.wx_system_font)
        self.coords_callback = None # callback function to display coordinates;
                                    # must be set elsewhere

    def open_file(self, filename, readonly=0):
        # first, create an editor window
        ed = editor.Editor(self, self.options)
        ed.open(filename)
        ed.SetReadOnly(readonly)
        path, shortname = os.path.split(filename)
        if readonly:
            shortname = shortname + "#" # indicates read-only in tabs
        self.AddPage(ed, shortname, true)

    def new(self):
        ed = editor.Editor(self, self.options)
        self.AddPage(ed, "[noname]", true)

    def get_current_page(self):
        idx = self.GetSelection()
        if idx > -1:
            return self.GetPage(idx)
        else:
            raise ValueError, "No current page"

    def save(self, filename):
        """ Save the current file. """
        ed = self.get_current_page()    # the editor window
        if ed.filename:
            ed.save(filename)
        else:
            ed.save_as(filename)

    def rename_tab(self, filename):
        """ Rename the current tab to an appropriate shortname. """
        path, shortname = os.path.split(filename)
        idx = self.GetSelection()
        self.SetPageText(idx, shortname)
        
    def rename_tab_2(self, shortname):
        """ Set the current tab to the given shortname, regardless what the
            filename is. """
        idx = self.GetSelection()
        if idx > -1:
            self.SetPageText(idx, shortname)

    def next_page(self):
        """ Move to the next page. """
        idx = self.GetSelection()
        if idx > -1:
            numpages = self.GetPageCount()
            if numpages <= 1:
                return  # don't bother doing anything
            idx = idx + 1
            if idx >= numpages:
                idx = 0
            self.SetSelection(idx)

    def previous_page(self):
        """ Move to the previous page. """
        idx = self.GetSelection()
        if idx > -1:
            numpages = self.GetPageCount()
            if numpages <= 1:
                return  # don't bother doing anything
            idx = idx - 1
            if idx < 0:
                idx = numpages - 1
            self.SetSelection(idx)

    ###
    ### shells

    # XXX maybe these should have their own separate objects...
    def python_shell(self):
        sh = shell.create_shell(self, self.options.shell_with_filling)
        #sh = shell.PythonShell(self)
        self.AddPage(sh, "*shell*", true)
        
    def python_shell_import(self, modulename):
        sh = shell.create_shell_and_import(self, modulename, 
         self.options.shell_with_filling)
        self.AddPage(sh, "*shell*", true)
        
    #def python_shell_with_filling(self):
    #    sh = shell.PythonShellFilling(self)
    #    self.AddPage(sh, "*shell*", true)

    def add_help(self, title, text):
        """ Add a helper window with the given title and text. """
        ed = editor.Editor(self, self.options)
        self.AddPage(ed, "*help* " + title, true)
        ed.InsertText(0, text)

    ###
    ### helper functions
    
    def get_editors(self):
        """ Get a list of all Editor instances. """
        editors = []
        for i in range(self.GetPageCount()):
            win = self.GetPage(i)
            if isinstance(win, editor.Editor):
                editors.append(win)
        return editors
        