# options.py

class Options:

    defaults = {
        "editor_width": 80,  # ?
        "editor_height": 25, # ?
        "editor_font": ("Courier New", 10),
        "system_font": ("Tahoma", 8),
        "autoindent": 1,
        "use_tabs": 0,
        "tabsize": 4,
        "show_line_numbers": 1,
        "show_whitespace": 0,
        "show_indentguides": 0,
        "folding": 0,
        "shell_with_filling": 0,
        "edge": 80,
        
        "filemask": "Python source (*.py)|*.py|"\
                    "Text files (*.txt)|*.txt|"\
                    "All files (*.*)|*.*",

        # syntax highlighting: file associations
        "file_assoc": {
            ".py": "Python",
        },

        # syntax highlighting: colors
        "syntax_highlighting": {
            "Python": {
                "default": "fore:#C0C0C0,back:#000000",
                "comment": "fore:#4040AF,back:#000000",
                "number": "fore:#B0B0D0,back:#000000",
                "triple": "fore:#4040AF,back:#000000",
                "triple_double": "fore:#4040AF,back:#000000",
                "string": "fore:#9090FF,back:#000000",
                "operator": "fore:#6060FF,back:#000000",
                "classname": "fore:#CCCCFF,back:#000000",
                "defname": "fore:#CCCCFF,back:#00000",
                "word": "fore:#FFFFFF,back:#000000",
                "character": "fore:#9090FF,back:#000000",
                "identifier": "fore:#C0C0C0,back:#000000",
                "commentblock": "fore:#4040AF,back:#000000",
                "stringeol": "fore:#FFFF00,back:#000000",
            },
        },
    }

    def __init__(self):
        for name, value in self.defaults.items():
            setattr(self, name, value)

    def load(self, filename):
        try:
            f = open(filename, "r")
        except:
            print "Could not open", filename
            return
        lines = f.readlines()
        f.close()
        for line in lines:
            if not line.strip():
                continue
            try:
                exec line
            except:
                print "Error in line:", `line`

        self.make_fonts()

    def make_fonts(self):
        facename, size = self.system_font
        import wxPython.wx as wx
        self.wx_system_font = wx.wxFont(size, wx.wxDEFAULT, wx.wxNORMAL, 
         wx.wxNORMAL, wx.false, facename)

