# shell.py

from wxPython.wx import *
from wxPython.lib.PyCrust import shell, version, filling

class ShellMixin:
    """ Methods that both versions of the shell should have. """
    def get_filename(self):
        """ Return filename for fileselector. """
        return "Python Shell at <0x%x>" % (id(self),)

class PythonShell(shell.Shell, ShellMixin):

    def __init__(self, parent):
        id = wxNewId()
        intro = "Welcome to PyCrust %s - The Flakiest Python Shell" % (
         version.VERSION)
        shell.Shell.__init__(self, parent, id, introText=intro)
        self.id = id
        
class PythonShellFilling(wxSplitterWindow, ShellMixin):

    def __init__(self, parent):
        id_shell = wxNewId()
        id_filling = wxNewId()
        intro = "Welcome to PyCrust %s - The Flakiest Python Shell" % (
         version.VERSION)
        wxSplitterWindow.__init__(self, parent, wxNewId(), size=(640,480))
        shellwin = shell.Shell(self, id_shell, introText=intro)
        fillingwin = filling.Filling(self, id_filling, size=(640,480),
         rootObject=shellwin.interp.locals, rootIsNamespace=1)
        self.SplitHorizontally(shellwin, fillingwin)
        
        # keep references around
        self.shellwin = shellwin
        self.fillingwin = fillingwin

def create_shell(parent, filling=0):
    if filling:
        return PythonShellFilling(parent)
    else:
        return PythonShell(parent)
        
def create_shell_and_import(parent, modulename, filling=0):
    """ Create a shell and import the given module in it. """
    sh = create_shell(parent, filling)
    if isinstance(sh, PythonShell):
        loc = sh.interp.locals
    else:
        loc = sh.shellwin.interp.locals
        
    # inject module in namespace
    m = __import__(modulename)
    loc[modulename] = m
    
    return sh