# tools.py

import os
import sys

def find_file(filename, paths=None):
    """ Find a file in a list of paths. If paths is not given, sys.path
        is used. 
        If the file is found, its full name is returned; otherwise, None is
        returned. 
    """
    if not paths:
        paths = sys.path
    for path in sys.path:
        fullname = os.path.join(path, filename)
        if os.path.exists(fullname):
            return fullname
    return None