# bloginfo_input.py
#

from Tkinter import *
import string
#
import input_dialog
import resource


class BloginfoInput(input_dialog.InputDialog):

    # In this dialog, fields from the bloginfo table are loosely coupled to the
    # input fields.
    # 1. When creating the Text widget (input field) for a certain field F, its
    # name will be self.blog_F.
    # 2. When loading and saving data, these properties are used to get all
    # field values known, generate dynamic SQL, etc.

    prefix = "blog_"

    def body(self, master):
        frame = Frame(master)
        
        f1 = self.create_inputbox(frame, "Blog title ::", "title", 40)
        f1.pack(side=TOP, fill=X, pady=1)

        f2 = self.create_inputbox(frame, "Blog description ::", "description", 
         40, 5)
        f2.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f1.inputbox, f2.inputbox)
        
        f2a = self.create_inputbox(frame, "Root ::", "root", 40)
        f2a.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f2.inputbox, f2a.inputbox)

        f3 = self.create_inputbox(frame, "Page template ::", 
         "page_template_name", 30)
        f3.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f2a.inputbox, f3.inputbox)

        f4 = self.create_inputbox(frame, "Entry template ::",
         "entry_template_name", 30)
        f4.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f3.inputbox, f4.inputbox)
        
        f5= self.create_inputbox(frame, "Archive method ::",
         "archive_method", 10)
        f5.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f4.inputbox, f5.inputbox)

        f6 = self.create_inputbox(frame, "Num. entries front page ::",
         "num_entries_fp", 5)
        f6.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f5.inputbox, f6.inputbox)

        f7 = self.create_inputbox(frame, "Default author ::",
         "default_author", 30)
        f7.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f6.inputbox, f7.inputbox)

        f8 = self.create_checkbox(frame, "Only post updated ::", 
         "only_post_updated")
        f8.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f7.inputbox, f8.checkbox)

        f9 = self.create_checkbox(frame, "Only publish updated ::", 
         "only_publish_updated")
        f9.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f8.checkbox, f9.checkbox)

        f10 = self.create_checkbox(frame, "Category archives ::", 
         "category_archives")
        f10.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f9.checkbox, f10.checkbox)
        
        f11 = self.create_checkbox(frame, "Generate RSS ::",
         "generate_rss")
        f11.pack(side=TOP, fill=X, pady=1)
        input_dialog.set_tablink(f10.checkbox, f11.checkbox)

        input_dialog.set_tablink(f11.checkbox, f1.inputbox)
        
        frame.pack(fill=BOTH, expand=YES)

        self.load() # !
        return frame


