# category_input.py

from Tkinter import *
import tkSimpleDialog
#
import dialog
import resource

def is_identifier(name):
    """ Return true if a string is a valid Python identifier. """
    import re
    m = re.match("[_A-Za-z][_A-Za-z0-9]*", name)
    return not not m

class CategoryInput(dialog.Dialog):

    def __init__(self, master, categories):
        self.categories = categories[:]

        dialog.Dialog.__init__(self, master, "Edit categories for this blog")

    def body(self, master):
        f = Frame(master)

        lbframe = Frame(f)
        self.listbox = self.create_listbox(lbframe)
        self.listbox.pack(side=LEFT, fill=BOTH)
        self.populate_listbox(self.listbox, self.categories)
        lbframe.pack(side=LEFT, fill=BOTH)

        bframe = Frame(f)

        b1 = Button(bframe, text="Add", command=self.add_category, 
         font=resource.SMALL_FONT)
        b1.pack(side=TOP, padx=10, pady=5, fill=X)
        
        b2 = Button(bframe, text="Edit", command=self.edit_category,
         font=resource.SMALL_FONT)
        b2.pack(side=TOP, padx=10, pady=5, fill=X)

        b3 = Button(bframe, text="Delete", command=self.delete_category,
         font=resource.SMALL_FONT)
        b3.pack(side=TOP, padx=10, pady=5, fill=X)

        bframe.pack(side=RIGHT, fill=BOTH)

        f.pack(fill=BOTH, expand=YES)

        return f

    def create_listbox(self, master):
        scrollbar = Scrollbar(master, orient=VERTICAL)
        listbox = Listbox(master, yscrollcommand=scrollbar.set)
        listbox.configure(font=resource.SMALL_FONT, background="white",
         width=20, height=10)
        scrollbar.config(command=listbox.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
        return listbox

    def populate_listbox(self, listbox, lst):
        for item in lst:
            listbox.insert(END, item)

    def get_selection(self, listbox):
        """ Return the index of the currently selected entry. Return -1 if
            nothing is selected. """
        items = listbox.curselection()
        try:
            items = map(int, items)
        except ValueError:
            pass
        
        if items:
            return items[0]
        else:
            return -1

    def add_category(self):
        name = tkSimpleDialog.askstring("Enter new category", "Name ::")
        if name:
            if name in self.categories:
                print "Category", name, "already exists!"
            elif not is_identifier(name):
                print name, "is not a valid identifier!"
            else:
                self.categories.append(name)
                self.listbox.insert(END, name)

    def edit_category(self):
        index = self.get_selection(self.listbox)
        if index < 0:
            return
        item = self.categories[index]
        
        name = tkSimpleDialog.askstring("Rename category", "Name ::",
         initialvalue=item)
        if name and name != item:
            if not is_identifier(name):
                print name, "is not a valid identifier!"
            elif name in self.categories:
                print "Category", name, "already exists!"
            else:
                self.categories[index] = name
                self.listbox.delete(ANCHOR)
                self.listbox.insert(ANCHOR, name)

    def delete_category(self):
        index = self.get_selection(self.listbox)
        if index < 0:
            return

        del self.categories[index]
        self.listbox.delete(ANCHOR)

