# cm.py
# Content-management classes.

import htmlmaker

class CM:
    """ One custom page. """

    def __init__(self, globalmod):
        self.globalmod = globalmod
    
    page_template = None
    entry_template = None
    target = None

    entry_html = ""
    page_html = ""

    # The order for templates is:
    # 1. If page_template is set, use that.
    # 2. If it's None, use page_html.
    # 3. If that is 'false' as well, use the default template.

    def get_entries(self, db):
        """ Override this to get the entries you want for this page. """
        return []

    def gen_html(self, db, blog):
        entries = self.get_entries(db)
        maker = htmlmaker.HTMLMaker(blog, self.page_template, 
         self.entry_template, globalmod=self.globalmod)
        if not self.page_template:
            if self.page_html:
                maker.page_template = self.page_html
            else:
                maker.page_template = open(blog.page_template_name, "rb").read()
        if not self.entry_template:
            if self.entry_html:
                maker.entry_template = self.entry_html
            else:
                maker.entry_template = open(blog.entry_template_name, 
                 "rb").read()

        html = maker.make_page(entries)
        return html


class CMRange:
    """ A range of custom pages. """
