# entrypicker.py

from Tkinter import *
#
import resource
import dialog

class EntryPicker(dialog.Dialog):

    def __init__(self, master, database):
        self.db = database
        self.selection = -1
        self.selected_id = 0
        self.rows = []

        dialog.Dialog.__init__(self, master, "Select an entry")
        
    def body(self, master):
        frame = Frame(master)

        self.listbox = self.create_listbox(frame)
        self.listbox.bind("<Double-Button-1>", self.ok_pressed)
        self.listbox.bind("<Down>", self.cursor_down)
        self.listbox.bind("<Up>", self.cursor_up)
        self.listbox.pack(side=TOP, fill=BOTH, expand=Y)

        frame.pack(fill=BOTH, expand=Y)
        return frame

    def create_listbox(self, master):
        scrollbar = Scrollbar(master, orient=VERTICAL)
        listbox = Listbox(master, yscrollcommand=scrollbar.set)
        listbox.configure(font=resource.SMALL_FONT, background="white",
         width=70)
        scrollbar.config(command=listbox.yview)
        scrollbar.pack(side=RIGHT, fill=Y)
        self.populate(listbox)
        return listbox

    def populate(self, listbox):
        cursor = self.db.conn.cursor()
        cursor.execute("""
         select blogentry_id, title, author, insert_date
         from blogentry
         order by blogentry_id desc
        """)
        
        rows = cursor.fetchall()
        for row in rows:
            s = "%s [%s]" % (row[1], row[3])
            listbox.insert(END, s)
        self.rows = rows

    def get_selection(self):
        """ Return the index of the currently selected entry. Return -1 if
            nothing is selected. """
        items = self.listbox.curselection()
        try:
            items = map(int, items)
        except ValueError:
            pass
        
        if items:
            return items[0]
        else:
            return -1

    def validate(self):
        self.selection = self.get_selection()
        if self.selection > -1:
            self.selected_id = self.rows[self.selection][0]
        return (self.selection != -1)

    def cursor_down(self, event=None): 
        # FIXME: this doesn't even work yet...
        index = self.get_selection()
        if index > -1:
            self.listbox.select_set(index+1)

    def cursor_up(self, event=None): 
        index = self.get_selection()
        if index > -1:
            self.listbox.select_set(index-1)


if __name__ == "__main__":

    root = Tk()

    entrypicker = EntryPicker(root, None)

    root.mainloop()

