# errors.py

from Tkinter import *
import cStringIO
import dialog
import resource
import traceback

EXCEPTION_INFO = \
"A Python exception occurred. Please report this error to the author "\
"(preferably with the complete pasted traceback below, and some "\
"information about what you were doing when it occurred).\n"

class ErrorDialog(dialog.Dialog):

    def __init__(self, parent, title="Error", message="An error occurred."):
        self.message = message
        dialog.Dialog.__init__(self, parent, title)
        
    def body(self, master):
        msglabel = Label(master, text=self.message, wraplength=200,
         justify=LEFT, font=resource.SMALL_FONT_BOLD, width=40)
        msglabel.pack(pady=10)

class ExceptionDialog(dialog.Dialog):

    def __init__(self, parent, title="An exception occurred"):
        dialog.Dialog.__init__(self, parent, title)
        
    def body(self, master):
    
        ftop = Frame(master)
        infolabel = Label(ftop, text=EXCEPTION_INFO, wraplength=500,
         justify=LEFT, font=resource.SMALL_FONT)
        infolabel.pack(side=LEFT, expand=NO, fill=X, pady=3)
        ftop.pack(side=TOP, expand=NO, fill=X)
    
        f = Frame(master)
        f.pack(side=TOP, expand=YES, fill=BOTH)

        scrollbar = Scrollbar(f, orient="vertical")
        scrollbar.pack(side=RIGHT, fill=Y)
        
        text = Text(f, width=80, height=15)
        text.configure(font=resource.FIXED_FONT_SMALLER, wrap=WORD)
        text.pack(side=LEFT, fill=BOTH, expand=YES)
        text["yscrollcommand"] = scrollbar.set
        scrollbar["command"] = text.yview

        f.text = text
        f.scrollbar = scrollbar
        
        # get the complete traceback
        c = cStringIO.StringIO()
        traceback.print_exc(file=c)
        
        text.insert(END, c.getvalue())
        