# renderer.py

import re
import string
import StringIO
import sys
import traceback

re_code_eval = re.compile("\<%.*?%\>", re.MULTILINE|re.DOTALL)
re_code_exec = re.compile("\<#.*?#\>", re.MULTILINE|re.DOTALL)

def render(template, globals):
    occs = re.findall(re_code_eval, template)
    for occ in occs:
        value = render_value_eval(occ, globals)
        template = string.replace(template, occ, value)
    occs = re.findall(re_code_exec, template)
    for occ in occs:
        value = render_value_exec(occ, globals)
        template = string.replace(template, occ, value)
    return template

def render_value_eval(code, globals):
    """ Render code, in the form of a string "<% something %>", to its value by
        evaluating (gasp!) it. """
    code = code[2:-2].strip()       
    value = eval(code, globals)
    return "%s" % (value)

def render_value_exec(code, globals):
    # A bit more complex than render_value_eval. We redirect sys.stdout to a
    # StringIO, so anything written to (the fake) sys.stdout, or printed, is
    # caught by it and placed in HTML instead. Name 'doc' is available as a
    # shorthand for sys.stdout.
    s = StringIO.StringIO()
    oldstdout, sys.stdout = sys.stdout, s
    code = restyle_code(code[2:-2].lstrip())
    globals["doc"] = sys.stdout
    try:
        exec code in globals
    except:
        print >> sys.stderr, "-----An error occurred:-----"
        traceback.print_exc() 
        print >> sys.stderr, "----------------------------"
    sys.stdout = oldstdout
    return s.getvalue()

# for some reason, \r\n as line ending is not acceptable for exec... so we
# convert that:
def restyle_code(code):
    if string.find(code, "\r\n") > -1:
        lines = string.split(code, "\r\n")
        code = string.join(lines, "\n")
    return code



if __name__ == "__main__":

    code = """\
Hi! My name is <% name %>. Pleased to meet ya,
I'm a funky creature.
Let's print some numbers, eh?
<#
for i in range(5):
    print i
#>
<% signature %>
    """

    name = "Hans"
    signature = "--\nhans@nowak.com"

    print render(code, globals())


