# selfish.py
# Emulation of Self-style objects in Python.

__version__ = "0.3"

class SelfMethod:
    def __init__(self, obj, f):
        self.obj = obj
        self.f = f
    def __call__(self, *args, **kwargs):
        return self.f(self.obj, *args, **kwargs)

class SelfObject:
    def __init__(self):
        self.__dict__["slots"] = {}
    def lookup(self, name):
        if name in self.slots.keys():
            return self.slots[name]
        for key, obj in self.slots.items():
            if key.endswith("_p"):
                result = obj.lookup(name)
                if result:
                    return result
        # nothing found...
        return None
        # more later...
    def __getattr__(self, name):
        result = self.lookup(name)
        if result is not None:
            if isinstance(result, SelfMethod):
                sm = SelfMethod(self, result.f)
                return sm
            return result
        raise AttributeError, name
    def __setattr__(self, name, value):
        if name.endswith("_p"):
            assert isinstance(value, SelfObject), \
             "Only objects can have the _p suffix"
        if callable(value) and not isinstance(value, SelfObject):
            if isinstance(value, SelfMethod):
                sm = SelfMethod(self, value.f)
                self.slots[name] = sm
            else:
                self.slots[name] = SelfMethod(self, value)
        else:
            self.slots[name] = value

clonable = SelfObject()
def copy(self):
    # overly simple version for testing purposes.
    so = self.__class__()
    for key, value in self.slots.items():
        setattr(so, key, value)
    return so
clonable.copy = copy

