# test_selfish.py

import unittest
import selfish

class TestSelfish(unittest.TestCase):
    
    def test_make_object(self):
        """ Make simple object """
        Point = selfish.SelfObject()    # "an object"
        Point.x = 0
        Point.y = 0
        def __repr__(self):
            return "Point(%s,%s)" % (self.x, self.y)
        def move(self, dx, dy):
            self.x += dx
            self.y += dy
        Point.__repr__ = __repr__
        Point.move = move
        
        self.assertEquals(repr(Point), "Point(0,0)")
        Point.move(4,5)
        self.assertEquals(repr(Point), "Point(4,5)")

    def test_inheritance(self):
        """ Inheritance """
        AccountMethods = selfish.SelfObject()
        def deposit(self, amount):
            self.balance += amount
        def withdraw(self, amount):
            if self.balance >= amount:
                self.balance = self.balance - amount
            else:
                raise ValueError, "Insufficient funds!"
        AccountMethods.deposit = deposit
        AccountMethods.withdraw = withdraw

        # make a prototype for a bank account
        BankAccount = selfish.SelfObject()
        BankAccount.methods_p = AccountMethods
        BankAccount.clonable_p = selfish.clonable
        BankAccount.balance = 0

        # create two accounts; they should (of course) be independent from each
        # other
        johns_account = BankAccount.copy()
        hanks_account = BankAccount.copy()
        self.assertEquals(johns_account.balance, 0)
        johns_account.deposit(100)
        self.assertEquals(hanks_account.balance, 0)
        self.assertEquals(johns_account.balance, 100)


def suite():
    s = unittest.makeSuite(TestSelfish)
    return unittest.TestSuite([s])

if __name__ == "__main__":

    #unittest.main()
    runner = unittest.TextTestRunner(verbosity = 2)
    runner.run(suite())
 
